import * as React from "react"

import { cn } from "@/lib/utils"
import { focusInput } from "@/lib/styles"

const InputTextarea = React.forwardRef<
  HTMLTextAreaElement,
  React.ComponentProps<"textarea">
>(({ className, ...props }, ref) => {
  return (
    <textarea
      className={cn(
        focusInput,
        "flex min-h-[80px] w-full rounded-md border border-input bg-background px-3 py-2 text-base disabled:cursor-not-allowed disabled:opacity-50 md:text-sm",
        className
      )}
      ref={ref}
      {...props}
    />
  )
})
InputTextarea.displayName = "InputTextarea"

export { InputTextarea }
